# 🎮 Picoo Quiz Creator - Web App

A semi-functional quiz creation web app developed for **Picoo**, made to help teachers easily create questions for the interactive group game **Quiztafette**.  
This project focuses on accessibility, ease of use, and a clean, user-friendly interface.

---

## 🧩 Project Goal

The goal of this project was to design and build a **quiz maker** tool that allows elementary school teachers to:

- Quickly add and manage quiz questions
- Use it in the classroom with Picoo’s Quiztafette game
- Provide a simple, visual, and intuitive experience
- Deliver a working digital prototype that could be tested and expanded

---

## 🛠 Features

- Add multiple choice quiz questions in a simple form
- Easy-to-use UI with live preview of added questions
- Clean layout with **slide-in animations**
- Custom **scrollbar styling**
- Glassmorphism effects for a modern look
- Responsive design, works on desktop and tablet
- Built with **HTML, CSS, and Vanilla JavaScript** (no frameworks)

---

## 🚀 How to Use

1. Download or clone the folder to your computer.
2. Open `index.html` in your browser.
3. Go to the right page, where the quiz creator is located.
4. Use the form to add quiz questions.
5. Questions appear directly in the list below.
6. (Optional) Add logic for exporting questions (e.g., to JSON) if needed.

---

## 📁 Folder Structu

picoo-quizmaker-2025/
├── css/
├── html/
├── icons/
├── images/
├── js/
├── index.html
└── README.md

## 🧠 Tools Used

- HTML5
- CSS3
- JavaScript (Vanilla)
- Figma (for UI & UX design)
- Visual Studio Code

---

## 🔍 Research & UX Process

Before building, we:

- Interviewed teachers to understand their needs
- Researched platforms like **Kahoot** and **Quizzes**
- Used **card sorting** to improve structure and flow
- Conducted **user testing** to gather feedback and improve usability

---

## 👨‍💻 Created By

This project was created as part of a semester assignment for a combination of Create That UX and Development.  
Team members: **Michal Marcinkowski** & **Finn Schoenmakers**

---

## 📬 Contact

If you have feedback or want to connect:

- 536921@student.fontys.nl (Michal Marcinkowski)
- finn.schoenmakers@student.fontys.nl (Finn Schoenmakers)
